﻿var errorLogs = {
    context: $(".v-errorLogs"),
    datatable: null,
    initializeDataTable: function (folder) {
        this.datatable = $(".h-errorLogs-table", this.context).a4datatable({
            advancedFilter: false,
            height: "full",
            ajaxAction: a4.getProjectAction("GetErrorLogs", "Diagnostics"),
            columns: [
                { "Title": resources.ServerName, "Data": "ServerName" },
                { "Title": resources.ErrorCode, "Data": "ErrorCode", "Type": "numeric" },
                { "Title": resources.ErrorLabel, "Data": "ErrorLabel" },
                { "Title": resources.Date, "Data": "DateTime", "Type": "date" },
                { "Title": resources.Description, "Data": "Description" }
            ],
            stateKey: "ErrorLogs",
            localizableTexts: { "All": resources.AllLogs, "Search": resources.SearchLogs },
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            }
        });
    }
}

$(document).ready(function () {
    if (errorLogs.context.length > 0) {
        errorLogs.initializeDataTable();
    }
});